<?php
namespace Getresponse\Sdk\Operation\Model;

use Getresponse\Sdk\Client\Operation\BaseModel;

class ShortCustomField extends BaseModel
{
    /** @var string */
    private $customFieldId = self::FIELD_NOT_SET;

    /** @var string */
    private $name = self::FIELD_NOT_SET;

    /** @var string */
    private $type = self::FIELD_NOT_SET;

    /** @var array */
    private $values = self::FIELD_NOT_SET;


    /**
     * @param string $customFieldId
     */
    public function setCustomFieldId($customFieldId)
    {
        $this->customFieldId = $customFieldId;
    }


    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }


    /**
     * @param string $type
     */
    public function setType($type)
    {
        $this->type = $type;
    }


    /**
     * @param array $values
     */
    public function setValues(array $values)
    {
        $this->values = $values;
    }


        public function jsonSerialize(): array
    {
        $data = [
            'customFieldId' => $this->customFieldId,
            'name' => $this->name,
            'type' => $this->type,
            'values' => $this->values,
        ];

        return $this->filterUnsetFields($data);
    }
}
